document.addEventListener('DOMContentLoaded', function() {
    const qrcodeDiv = document.getElementById('qrcode');
    const urlDisplay = document.getElementById('url-display');

    // Função para exibir mensagens de erro
    function displayError(message) {
        qrcodeDiv.innerHTML = `<p style="color: #A94442; background: #F2DEDE; border: 1px solid #EBCCD1; padding: 8px; border-radius: 4px; text-align: center; font-size: 0.9em;">${message}</p>`;
        urlDisplay.textContent = 'Status: Erro';
        document.querySelector('h1').textContent = 'Falha na Geração';
        console.error("ERRO EXTENSÃO QR CODE:", message);
    }

    // 1. Obter a URL da Aba Ativa
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        if (!tabs || tabs.length === 0 || !tabs[0].url) {
            displayError("Não foi possível obter a URL da aba ativa.");
            return;
        }

        const currentUrl = tabs[0].url;

        // Regra do Chrome: Extensões não podem acessar URLs internas
        if (currentUrl.startsWith('chrome://') || currentUrl.startsWith('chrome-extension://')) {
             displayError("Não é permitido gerar QR Code para páginas internas do navegador (ex: chrome://settings, páginas de extensão). Tente em um site comum.");
             return;
        }

        // 2. Exibir a URL e Título
        urlDisplay.textContent = 'URL: ' + currentUrl;
        document.querySelector('h1').textContent = 'QR Code da Página';

        // 3. Gerar o QR Code
        // **Removemos a checagem de CDN aqui**
        if (typeof QRCode !== 'undefined') {
            try {
                qrcodeDiv.innerHTML = ''; 
                
                new QRCode(qrcodeDiv, {
                    text: currentUrl,
                    width: 250,
                    height: 250,
                    colorDark : "#000000",
                    colorLight : "#F4F5F7",
                    correctLevel : QRCode.CorrectLevel.H 
                });

            } catch (e) {
                displayError("Falha na geração: Erro interno da biblioteca. Verifique a URL.");
                console.error(e); // Adicionando o log do erro para debug
            }
        } else {
            // Nova mensagem de erro caso o qrcode.js não carregue
            displayError("A biblioteca de QR Code não foi carregada. Verifique se o arquivo qrcode.js está na pasta correta.");
        }
    });
});